#!/bin/bash

# This is the FoundryVTT export plugin used to generate these markdown files:
# https://foundryvtt.com/packages/export-markdown

set -e

SRC=$1
DST=$2

# Create dokuwiki files "in place" or rather, alongside markdown
find "$SRC" -iname "*.md" -type f -exec sh -c 'pandoc -f markdown -t dokuwiki "${0}" -o "${0%.md}.txt"' {} \;

# Copy over the dokuwiki .txt files, flatten along the way:
# FoundryVTT uses uuids so names shouldn't clash
find "$SRC" -mindepth 1 -type f -iname "*.txt" -exec cp -t "$DST" -i '{}' +

# Move into destination folder for renaming
cd $DST

# Do the rename
rename 'y/A-Z/a-z/' *

# While here, spit out a TOC of top level journal name links
# TODO: Make the dg:foundry: dokuwiki namespace prefix configurable
find . -regex '.*journalentry\.[a-z0-9]+\.txt' -exec grep -m 1 -H '.' {} \; | sed -E 's/\.\/(journalentry\.[a-z0-9]+)\.txt:====== (.*) ======/  \* [[dg:foundry:\1|\2]]/'

# Go back
cd -